START TRANSACTION;
-- @@ -466,7 +466,7 @@ CREATE TABLE config (
--  	ok_unack_style           integer         DEFAULT '1'               NOT NULL,
--  	ok_ack_style             integer         DEFAULT '1'               NOT NULL,
--  	snmptrap_logging         integer         DEFAULT '1'               NOT NULL,
-- -	server_check_interval    integer         DEFAULT '60'              NOT NULL,
-- +	server_check_interval    integer         DEFAULT '10'              NOT NULL,
--  	PRIMARY KEY (configid)
--  );
ALTER TABLE config ALTER COLUMN server_check_interval SET DEFAULT '10';

UPDATE config SET server_check_interval=10 WHERE server_check_interval=60;

-- -INSERT INTO users (userid,alias,name,surname,passwd,url,autologin,autologout,lang,refresh,type,theme,rows_per_page) values ('1','Admin','Zabbix','Administrator','5fce1b3e34b520afeffb37ce08c7cd66','','1','0','en_GB','30','3','originalblue','50');
-- -INSERT INTO users (userid,alias,name,surname,passwd,url,autologin,autologout,lang,refresh,type,theme,rows_per_page) values ('2','guest','Default','User','d41d8cd98f00b204e9800998ecf8427e','','0','900','en_GB','30','1','default.css','50');
-- +INSERT INTO users (userid,alias,name,surname,passwd,url,autologin,autologout,lang,refresh,type,theme,rows_per_page) values ('1','Admin','Zabbix','Administrator','5fce1b3e34b520afeffb37ce08c7cd66','','1','0','en_GB','30','3','default','50');
-- +INSERT INTO users (userid,alias,name,surname,passwd,url,autologin,autologout,lang,refresh,type,theme,rows_per_page) values ('2','guest','Default','User','d41d8cd98f00b204e9800998ecf8427e','','0','900','en_GB','30','1','default','50');
UPDATE users SET theme='default' WHERE userid=1;
UPDATE users SET theme='default' WHERE userid=2;

-- -INSERT INTO actions (actionid,name,eventsource,evaltype,status,esc_period,def_shortdata,def_longdata,recovery_msg,r_shortdata,r_longdata) values ('3','Report problems to Zabbix administrators','0','0','0','3600','{TRIGGER.STATUS}: {TRIGGER.NAME}','Trigger: {TRIGGER.NAME}
UPDATE actions SET status=1,
def_longdata='Trigger: {TRIGGER.NAME}
Trigger status: {TRIGGER.STATUS}
Trigger severity: {TRIGGER.SEVERITY}
Trigger URL: {TRIGGER.URL}

Item values:

1. {ITEM.NAME1} ({HOST.NAME1}:{ITEM.KEY1}): {ITEM.VALUE1}
2. {ITEM.NAME2} ({HOST.NAME2}:{ITEM.KEY2}): {ITEM.VALUE2}
3. {ITEM.NAME3} ({HOST.NAME3}:{ITEM.KEY3}): {ITEM.VALUE3}',
r_longdata='Trigger: {TRIGGER.NAME}
Trigger status: {TRIGGER.STATUS}
Trigger severity: {TRIGGER.SEVERITY}
Trigger URL: {TRIGGER.URL}

Item values:

1. {ITEM.NAME1} ({HOST.NAME1}:{ITEM.KEY1}): {ITEM.VALUE1}
2. {ITEM.NAME2} ({HOST.NAME2}:{ITEM.KEY2}): {ITEM.VALUE2}
3. {ITEM.NAME3} ({HOST.NAME3}:{ITEM.KEY3}): {ITEM.VALUE3}'
  WHERE actionid=3;

-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('10010','{12586}>5','Processor load is too high on {HOSTNAME}','','0','2','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('10011','{12555}>30','Too many processes running on {HOSTNAME}','','0','2','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('10012','{12580}<50','Lack of free swap space on {HOSTNAME}','','0','2','It probably means that the systems requires more physical memory.',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('10016','{10199}>0','/etc/passwd has been changed on {HOSTNAME}','','0','2','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('10021','{12583}<0','{HOSTNAME} has just been restarted','','0','1','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('10041','{10204}<256','Configured max number of processes is too low on {HOSTNAME}','','0','1','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('10042','{12553}<1024','Configured max number of opened files is too low on {HOSTNAME}','','0','1','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('10043','{10208}>0','Hostname was changed on {HOSTNAME}','','0','1','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('10044','{10207}>0','Host information was changed on {HOSTNAME}','','0','1','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('10190','{10233}>300','Too many processes on {HOSTNAME}','','0','2','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13000','{12144}<20M','Lack of available memory on server {HOSTNAME}','','0','3','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13010','0','WEB (HTTP) server is down on {HOSTNAME}','','0','3','',NULL,'0','0');

-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('10010','{12586}>5','Processor load is too high on {HOST.NAME}','','0','2','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('10011','{12555}>30','Too many processes running on {HOST.NAME}','','0','2','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('10012','{12580}<50','Lack of free swap space on {HOST.NAME}','','0','2','It probably means that the systems requires more physical memory.',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('10016','{10199}>0','/etc/passwd has been changed on {HOST.NAME}','','0','2','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('10021','{12583}<0','{HOST.NAME} has just been restarted','','0','1','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('10041','{10204}<256','Configured max number of processes is too low on {HOST.NAME}','','0','1','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('10042','{12553}<1024','Configured max number of opened files is too low on {HOST.NAME}','','0','1','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('10043','{10208}>0','Hostname was changed on {HOST.NAME}','','0','1','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('10044','{10207}>0','Host information was changed on {HOST.NAME}','','0','1','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('10190','{10233}>300','Too many processes on {HOST.NAME}','','0','2','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13000','{12144}<20M','Lack of available memory on server {HOST.NAME}','','0','3','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13010','0','WEB (HTTP) server is down on {HOST.NAME}','','0','3','',NULL,'0','0');

UPDATE triggers SET description='Processor load is too high on {HOST.NAME}' WHERE triggerid=10010;
UPDATE triggers SET description='Too many processes running on {HOST.NAME}' WHERE triggerid=10011;
UPDATE triggers SET description='Lack of free swap space on {HOST.NAME}' WHERE triggerid=10012;
UPDATE triggers SET description='/etc/passwd has been changed on {HOST.NAME}' WHERE triggerid=10016;
UPDATE triggers SET description='{HOST.NAME} has just been restarted' WHERE triggerid=10021;
UPDATE triggers SET description='Configured max number of processes is too low on {HOST.NAME}' WHERE triggerid=10041;
UPDATE triggers SET description='Configured max number of opened files is too low on {HOST.NAME}' WHERE triggerid=10042;
UPDATE triggers SET description='Hostname was changed on {HOST.NAME}' WHERE triggerid=10043;
UPDATE triggers SET description='Host information was changed on {HOST.NAME}' WHERE triggerid=10044;
UPDATE triggers SET description='Too many processes on {HOST.NAME}' WHERE triggerid=10190;
UPDATE triggers SET description='Lack of available memory on server {HOST.NAME}' WHERE triggerid=13000;
UPDATE triggers SET description='WEB (HTTP) server is down on {HOST.NAME}' WHERE triggerid=13010;

-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13025','{12549}=1','Zabbix agent on {HOSTNAME} is unreachable for 5 minutes','','0','3','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13026','{12926}>0','Version of zabbix_agent(d) was changed on {HOSTNAME}','','0','1','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13025','{12549}=1','Zabbix agent on {HOST.NAME} is unreachable for 5 minutes','','0','3','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13026','{12926}>0','Version of zabbix_agent(d) was changed on {HOST.NAME}','','0','1','',NULL,'0','0');

UPDATE triggers SET description='Zabbix agent on {HOST.NAME} is unreachable for 5 minutes' WHERE triggerid=13025;
UPDATE triggers SET description='Version of zabbix_agent(d) was changed on {HOST.NAME}' WHERE triggerid=13026;


-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13133','{12661}=0','SSH service is down on {HOSTNAME}','','0','3','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13134','{12333}=0','IMAP service is down on {HOSTNAME}','','0','3','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13135','{12334}=0','POP3 service is down on {HOSTNAME}','','0','3','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13136','{12335}=0','HTTP service is down on {HOSTNAME}','','0','3','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13137','{12336}=0','FTP service is down on {HOSTNAME}','','0','3','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13138','{12345}=0','NNTP service is down on {HOSTNAME}','','0','3','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13139','{12657}>1','ICMP ping response too slow from {HOSTNAME}','','0','2','Host reponses to ICMP ping but too slowly. Might be CPU load on host or network traffic causing this.',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13243','{12589}>20','Disk I/O is overloaded on {HOSTNAME}','','0','2','OS spends significant time waiting for I/O (input/output) operations. It could be indicator of performance issues with storage system.',NULL,'0','0');

-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13133','{12661}=0','SSH service is down on {HOST.NAME}','','0','3','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13134','{12333}=0','IMAP service is down on {HOST.NAME}','','0','3','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13135','{12334}=0','POP3 service is down on {HOST.NAME}','','0','3','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13136','{12335}=0','HTTP service is down on {HOST.NAME}','','0','3','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13137','{12336}=0','FTP service is down on {HOST.NAME}','','0','3','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13138','{12345}=0','NNTP service is down on {HOST.NAME}','','0','3','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13139','{12657}>1','ICMP ping response too slow from {HOST.NAME}','','0','2','Host reponses to ICMP ping but too slowly. Might be CPU load on host or network traffic causing this.',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13243','{12589}>20','Disk I/O is overloaded on {HOST.NAME}','','0','2','OS spends significant time waiting for I/O (input/output) operations. It could be indicator of performance issues with storage system.',NULL,'0','0');

UPDATE triggers SET description='SSH service is down on {HOST.NAME}' WHERE triggerid=13133;
UPDATE triggers SET description='IMAP service is down on {HOST.NAME}' WHERE triggerid=13134;
UPDATE triggers SET description='POP3 service is down on {HOST.NAME}' WHERE triggerid=13135;
UPDATE triggers SET description='HTTP service is down on {HOST.NAME}' WHERE triggerid=13136;
UPDATE triggers SET description='FTP service is down on {HOST.NAME}' WHERE triggerid=13137;
UPDATE triggers SET description='NNTP service is down on {HOST.NAME}' WHERE triggerid=13138;
UPDATE triggers SET description='ICMP ping response too slow from {HOST.NAME}' WHERE triggerid=13139;
UPDATE triggers SET description='Disk I/O is overloaded on {HOST.NAME}' WHERE triggerid=13243;


-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13277','{12659}=0','HTTPS service is down on {HOSTNAME}','','0','3','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13279','{12663}=0','LDAP service is down on {HOSTNAME}','','0','3','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13281','{12665}=0','NTP service is down on {HOSTNAME}','','0','3','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13283','{12667}=0','SMTP service is down on {HOSTNAME}','','0','3','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13285','{12669}=0','Telnet service is down on {HOSTNAME}','','0','3','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13287','{12671}=1','Operational status was changed on {HOSTNAME} interface {#SNMPVALUE}','','0','1','',NULL,'0','2');

-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13277','{12659}=0','HTTPS service is down on {HOST.NAME}','','0','3','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13279','{12663}=0','LDAP service is down on {HOST.NAME}','','0','3','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13281','{12665}=0','NTP service is down on {HOST.NAME}','','0','3','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13283','{12667}=0','SMTP service is down on {HOST.NAME}','','0','3','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13285','{12669}=0','Telnet service is down on {HOST.NAME}','','0','3','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13287','{12671}=1','Operational status was changed on {HOST.NAME} interface {#SNMPVALUE}','','0','1','',NULL,'0','2');

UPDATE triggers SET description='HTTPS service is down on {HOST.NAME}' WHERE triggerid=13277;
UPDATE triggers SET description='LDAP service is down on {HOST.NAME}' WHERE triggerid=13279;
UPDATE triggers SET description='NTP service is down on {HOST.NAME}' WHERE triggerid=13281;
UPDATE triggers SET description='SMTP service is down on {HOST.NAME}' WHERE triggerid=13283;
UPDATE triggers SET description='Telnet service is down on {HOST.NAME}' WHERE triggerid=13285;
UPDATE triggers SET description='Operational status was changed on {HOST.NAME} interface {#SNMPVALUE}' WHERE triggerid=13287;

-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13330','{12717}<1024','Configured max number of opened files is too low on {HOSTNAME}','','0','1','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13331','{12718}<256','Configured max number of processes is too low on {HOSTNAME}','','0','1','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13332','{12719}>30','Too many processes running on {HOSTNAME}','','0','2','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13333','{12720}>300','Too many processes on {HOSTNAME}','','0','2','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13334','{12721}>5','Processor load is too high on {HOSTNAME}','','0','2','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13336','{12723}>0','Hostname was changed on {HOSTNAME}','','0','1','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13337','{12724}<50','Lack of free swap space on {HOSTNAME}','','0','2','It probably means that the systems requires more physical memory.',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13338','{12725}>0','Host information was changed on {HOSTNAME}','','0','1','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13339','{12726}<0','{HOSTNAME} has just been restarted','','0','1','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13340','{12727}>0','/etc/passwd has been changed on {HOSTNAME}','','0','2','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13341','{12728}<20M','Lack of available memory on server {HOSTNAME}','','0','3','',NULL,'0','0');

-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13330','{12717}<1024','Configured max number of opened files is too low on {HOST.NAME}','','0','1','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13331','{12718}<256','Configured max number of processes is too low on {HOST.NAME}','','0','1','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13332','{12719}>30','Too many processes running on {HOST.NAME}','','0','2','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13333','{12720}>300','Too many processes on {HOST.NAME}','','0','2','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13334','{12721}>5','Processor load is too high on {HOST.NAME}','','0','2','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13336','{12723}>0','Hostname was changed on {HOST.NAME}','','0','1','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13337','{12724}<50','Lack of free swap space on {HOST.NAME}','','0','2','It probably means that the systems requires more physical memory.',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13338','{12725}>0','Host information was changed on {HOST.NAME}','','0','1','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13339','{12726}<0','{HOST.NAME} has just been restarted','','0','1','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13340','{12727}>0','/etc/passwd has been changed on {HOST.NAME}','','0','2','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13341','{12728}<20M','Lack of available memory on server {HOST.NAME}','','0','3','',NULL,'0','0');

UPDATE triggers SET description='Configured max number of opened files is too low on {HOST.NAME}' WHERE triggerid=13330;
UPDATE triggers SET description='Configured max number of processes is too low on {HOST.NAME}' WHERE triggerid=13331;
UPDATE triggers SET description='Too many processes running on {HOST.NAME}' WHERE triggerid=13332;
UPDATE triggers SET description='Too many processes on {HOST.NAME}' WHERE triggerid=13333;
UPDATE triggers SET description='Processor load is too high on {HOST.NAME}' WHERE triggerid=13334;
UPDATE triggers SET description='Hostname was changed on {HOST.NAME}' WHERE triggerid=13336;
UPDATE triggers SET description='Lack of free swap space on {HOST.NAME}' WHERE triggerid=13337;
UPDATE triggers SET description='Host information was changed on {HOST.NAME}' WHERE triggerid=13338;
UPDATE triggers SET description='{HOST.NAME} has just been restarted' WHERE triggerid=13339;
UPDATE triggers SET description='/etc/passwd has been changed on {HOST.NAME}' WHERE triggerid=13340;
UPDATE triggers SET description='Lack of available memory on server {HOST.NAME}' WHERE triggerid=13341;


-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13346','{12733}<1024','Configured max number of opened files is too low on {HOSTNAME}','','0','1','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13347','{12734}<256','Configured max number of processes is too low on {HOSTNAME}','','0','1','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13348','{12735}>30','Too many processes running on {HOSTNAME}','','0','2','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13349','{12736}>300','Too many processes on {HOSTNAME}','','0','2','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13350','{12737}>5','Processor load is too high on {HOSTNAME}','','0','2','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13352','{12739}>0','Hostname was changed on {HOSTNAME}','','0','1','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13353','{12740}<50','Lack of free swap space on {HOSTNAME}','','0','2','It probably means that the systems requires more physical memory.',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13354','{12741}>0','Host information was changed on {HOSTNAME}','','0','1','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13355','{12742}<0','{HOSTNAME} has just been restarted','','0','1','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13356','{12743}>0','/etc/passwd has been changed on {HOSTNAME}','','0','2','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13357','{12744}<20M','Lack of available memory on server {HOSTNAME}','','0','3','',NULL,'0','0');

-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13346','{12733}<1024','Configured max number of opened files is too low on {HOST.NAME}','','0','1','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13347','{12734}<256','Configured max number of processes is too low on {HOST.NAME}','','0','1','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13348','{12735}>30','Too many processes running on {HOST.NAME}','','0','2','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13349','{12736}>300','Too many processes on {HOST.NAME}','','0','2','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13350','{12737}>5','Processor load is too high on {HOST.NAME}','','0','2','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13352','{12739}>0','Hostname was changed on {HOST.NAME}','','0','1','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13353','{12740}<50','Lack of free swap space on {HOST.NAME}','','0','2','It probably means that the systems requires more physical memory.',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13354','{12741}>0','Host information was changed on {HOST.NAME}','','0','1','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13355','{12742}<0','{HOST.NAME} has just been restarted','','0','1','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13356','{12743}>0','/etc/passwd has been changed on {HOST.NAME}','','0','2','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13357','{12744}<20M','Lack of available memory on server {HOST.NAME}','','0','3','',NULL,'0','0');

UPDATE triggers SET description='Configured max number of opened files is too low on {HOST.NAME}' WHERE triggerid=13346;
UPDATE triggers SET description='Configured max number of processes is too low on {HOST.NAME}' WHERE triggerid=13347;
UPDATE triggers SET description='Too many processes running on {HOST.NAME}' WHERE triggerid=13348;
UPDATE triggers SET description='Too many processes on {HOST.NAME}' WHERE triggerid=13349;
UPDATE triggers SET description='Processor load is too high on {HOST.NAME}' WHERE triggerid=13350;
UPDATE triggers SET description='Hostname was changed on {HOST.NAME}' WHERE triggerid=13352;
UPDATE triggers SET description='Lack of free swap space on {HOST.NAME}' WHERE triggerid=13353;
UPDATE triggers SET description='Host information was changed on {HOST.NAME}' WHERE triggerid=13354;
UPDATE triggers SET description='{HOST.NAME} has just been restarted' WHERE triggerid=13355;
UPDATE triggers SET description='/etc/passwd has been changed on {HOST.NAME}' WHERE triggerid=13356;
UPDATE triggers SET description='Lack of available memory on server {HOST.NAME}' WHERE triggerid=13357;


-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13364','{12751}>30','Too many processes running on {HOSTNAME}','','0','2','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13365','{12752}>300','Too many processes on {HOSTNAME}','','0','2','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13366','{12753}>5','Processor load is too high on {HOSTNAME}','','0','2','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13367','{12828}>20','Disk I/O is overloaded on {HOSTNAME}','','0','2','OS spends significant time waiting for I/O (input/output) operations. It could be indicator of performance issues with storage system.',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13368','{12755}>0','Hostname was changed on {HOSTNAME}','','0','1','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13370','{12757}>0','Host information was changed on {HOSTNAME}','','0','1','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13371','{12758}<0','{HOSTNAME} has just been restarted','','0','1','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13372','{12759}>0','/etc/passwd has been changed on {HOSTNAME}','','0','2','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13373','{12760}<20M','Lack of available memory on server {HOSTNAME}','','0','3','',NULL,'0','0');

-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13364','{12751}>30','Too many processes running on {HOST.NAME}','','0','2','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13365','{12752}>300','Too many processes on {HOST.NAME}','','0','2','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13366','{12753}>5','Processor load is too high on {HOST.NAME}','','0','2','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13367','{12828}>20','Disk I/O is overloaded on {HOST.NAME}','','0','2','OS spends significant time waiting for I/O (input/output) operations. It could be indicator of performance issues with storage system.',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13368','{12755}>0','Hostname was changed on {HOST.NAME}','','0','1','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13370','{12757}>0','Host information was changed on {HOST.NAME}','','0','1','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13371','{12758}<0','{HOST.NAME} has just been restarted','','0','1','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13372','{12759}>0','/etc/passwd has been changed on {HOST.NAME}','','0','2','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13373','{12760}<20M','Lack of available memory on server {HOST.NAME}','','0','3','',NULL,'0','0');

UPDATE triggers SET description='Too many processes running on {HOST.NAME}' WHERE triggerid=13364;
UPDATE triggers SET description='Too many processes on {HOST.NAME}' WHERE triggerid=13365;
UPDATE triggers SET description='Processor load is too high on {HOST.NAME}' WHERE triggerid=13366;
UPDATE triggers SET description='Disk I/O is overloaded on {HOST.NAME}' WHERE triggerid=13367;
UPDATE triggers SET description='Hostname was changed on {HOST.NAME}' WHERE triggerid=13368;
UPDATE triggers SET description='Host information was changed on {HOST.NAME}' WHERE triggerid=13370;
UPDATE triggers SET description='{HOST.NAME} has just been restarted' WHERE triggerid=13371;
UPDATE triggers SET description='/etc/passwd has been changed on {HOST.NAME}' WHERE triggerid=13372;
UPDATE triggers SET description='Lack of available memory on server {HOST.NAME}' WHERE triggerid=13373;

-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13382','{12769}>5','Processor load is too high on {HOSTNAME}','','0','2','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13384','{12771}>0','Hostname was changed on {HOSTNAME}','','0','1','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13386','{12773}>0','Host information was changed on {HOSTNAME}','','0','1','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13388','{12775}>0','/etc/passwd has been changed on {HOSTNAME}','','0','2','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13389','{12776}<20M','Lack of available memory on server {HOSTNAME}','','0','3','',NULL,'0','0');

-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13382','{12769}>5','Processor load is too high on {HOST.NAME}','','0','2','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13384','{12771}>0','Hostname was changed on {HOST.NAME}','','0','1','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13386','{12773}>0','Host information was changed on {HOST.NAME}','','0','1','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13388','{12775}>0','/etc/passwd has been changed on {HOST.NAME}','','0','2','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13389','{12776}<20M','Lack of available memory on server {HOST.NAME}','','0','3','',NULL,'0','0');

UPDATE triggers SET description='Processor load is too high on {HOST.NAME}' WHERE triggerid=13382;
UPDATE triggers SET description='Hostname was changed on {HOST.NAME}' WHERE triggerid=13384;
UPDATE triggers SET description='Host information was changed on {HOST.NAME}' WHERE triggerid=13386;
UPDATE triggers SET description='/etc/passwd has been changed on {HOST.NAME}' WHERE triggerid=13388;
UPDATE triggers SET description='Lack of available memory on server {HOST.NAME}' WHERE triggerid=13389;

-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13395','{12782}<256','Configured max number of processes is too low on {HOSTNAME}','','0','1','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13396','{12783}>30','Too many processes running on {HOSTNAME}','','0','2','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13397','{12784}>300','Too many processes on {HOSTNAME}','','0','2','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13398','{12785}>5','Processor load is too high on {HOSTNAME}','','0','2','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13399','{12786}>20','Disk I/O is overloaded on {HOSTNAME}','','0','2','OS spends significant time waiting for I/O (input/output) operations. It could be indicator of performance issues with storage system.',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13400','{12787}>0','Hostname was changed on {HOSTNAME}','','0','1','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13401','{12788}<50','Lack of free swap space on {HOSTNAME}','','0','2','It probably means that the systems requires more physical memory.',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13402','{12789}>0','Host information was changed on {HOSTNAME}','','0','1','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13403','{12790}<0','{HOSTNAME} has just been restarted','','0','1','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13404','{12791}>0','/etc/passwd has been changed on {HOSTNAME}','','0','2','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13405','{12792}<20M','Lack of available memory on server {HOSTNAME}','','0','3','',NULL,'0','0');

-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13395','{12782}<256','Configured max number of processes is too low on {HOST.NAME}','','0','1','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13396','{12783}>30','Too many processes running on {HOST.NAME}','','0','2','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13397','{12784}>300','Too many processes on {HOST.NAME}','','0','2','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13398','{12785}>5','Processor load is too high on {HOST.NAME}','','0','2','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13399','{12786}>20','Disk I/O is overloaded on {HOST.NAME}','','0','2','OS spends significant time waiting for I/O (input/output) operations. It could be indicator of performance issues with storage system.',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13400','{12787}>0','Hostname was changed on {HOST.NAME}','','0','1','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13401','{12788}<50','Lack of free swap space on {HOST.NAME}','','0','2','It probably means that the systems requires more physical memory.',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13402','{12789}>0','Host information was changed on {HOST.NAME}','','0','1','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13403','{12790}<0','{HOST.NAME} has just been restarted','','0','1','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13404','{12791}>0','/etc/passwd has been changed on {HOST.NAME}','','0','2','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13405','{12792}<20M','Lack of available memory on server {HOST.NAME}','','0','3','',NULL,'0','0');

UPDATE triggers SET description='Configured max number of processes is too low on {HOST.NAME}' WHERE triggerid=13395;
UPDATE triggers SET description='Too many processes running on {HOST.NAME}' WHERE triggerid=13396;
UPDATE triggers SET description='Too many processes on {HOST.NAME}' WHERE triggerid=13397;
UPDATE triggers SET description='Processor load is too high on {HOST.NAME}' WHERE triggerid=13398;
UPDATE triggers SET description='Disk I/O is overloaded on {HOST.NAME}' WHERE triggerid=13399;
UPDATE triggers SET description='Hostname was changed on {HOST.NAME}' WHERE triggerid=13400;
UPDATE triggers SET description='Lack of free swap space on {HOST.NAME}' WHERE triggerid=13401;
UPDATE triggers SET description='Host information was changed on {HOST.NAME}' WHERE triggerid=13402;
UPDATE triggers SET description='{HOST.NAME} has just been restarted' WHERE triggerid=13403;
UPDATE triggers SET description='/etc/passwd has been changed on {HOST.NAME}' WHERE triggerid=13404;
UPDATE triggers SET description='Lack of available memory on server {HOST.NAME}' WHERE triggerid=13405;

-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13410','{12797}<1024','Configured max number of opened files is too low on {HOSTNAME}','','0','1','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13411','{12798}<256','Configured max number of processes is too low on {HOSTNAME}','','0','1','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13414','{12801}>5','Processor load is too high on {HOSTNAME}','','0','2','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13416','{12803}>0','Hostname was changed on {HOSTNAME}','','0','1','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13418','{12805}>0','Host information was changed on {HOSTNAME}','','0','1','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13419','{12806}<0','{HOSTNAME} has just been restarted','','0','1','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13420','{12807}>0','/etc/passwd has been changed on {HOSTNAME}','','0','2','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13421','{12808}<20M','Lack of available memory on server {HOSTNAME}','','0','3','',NULL,'0','0');

-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13410','{12797}<1024','Configured max number of opened files is too low on {HOST.NAME}','','0','1','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13411','{12798}<256','Configured max number of processes is too low on {HOST.NAME}','','0','1','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13414','{12801}>5','Processor load is too high on {HOST.NAME}','','0','2','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13416','{12803}>0','Hostname was changed on {HOST.NAME}','','0','1','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13418','{12805}>0','Host information was changed on {HOST.NAME}','','0','1','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13419','{12806}<0','{HOST.NAME} has just been restarted','','0','1','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13420','{12807}>0','/etc/passwd has been changed on {HOST.NAME}','','0','2','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13421','{12808}<20M','Lack of available memory on server {HOST.NAME}','','0','3','',NULL,'0','0');


UPDATE triggers SET description='Configured max number of opened files is too low on {HOST.NAME}' WHERE triggerid=13410;
UPDATE triggers SET description='Configured max number of processes is too low on {HOST.NAME}' WHERE triggerid=13411;
UPDATE triggers SET description='Processor load is too high on {HOST.NAME}' WHERE triggerid=13414;
UPDATE triggers SET description='Hostname was changed on {HOST.NAME}' WHERE triggerid=13416;
UPDATE triggers SET description='Host information was changed on {HOST.NAME}' WHERE triggerid=13418;
UPDATE triggers SET description='{HOST.NAME} has just been restarted' WHERE triggerid=13419;
UPDATE triggers SET description='/etc/passwd has been changed on {HOST.NAME}' WHERE triggerid=13420;
UPDATE triggers SET description='Lack of available memory on server {HOST.NAME}' WHERE triggerid=13421;


-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13425','{12812}>0','Host information was changed on {HOSTNAME}','','0','3','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13428','{12815}<600','{HOSTNAME} has just been restarted','','0','3','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13430','{12817}>300','Too many processes on {HOSTNAME}','','0','3','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13431','{12818}<100000','Lack of free swap space on {HOSTNAME}','','0','3','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13433','{12820}<10000','Lack of free memory on server {HOSTNAME}','','0','3','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13435','{12822}>5','Processor load is too high on {HOSTNAME}','','0','3','',NULL,'0','0');

-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13425','{12812}>0','Host information was changed on {HOST.NAME}','','0','3','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13428','{12815}<600','{HOST.NAME} has just been restarted','','0','3','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13430','{12817}>300','Too many processes on {HOST.NAME}','','0','3','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13431','{12818}<100000','Lack of free swap space on {HOST.NAME}','','0','3','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13433','{12820}<10000','Lack of free memory on server {HOST.NAME}','','0','3','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13435','{12822}>5','Processor load is too high on {HOST.NAME}','','0','3','',NULL,'0','0');


UPDATE triggers SET description='Host information was changed on {HOST.NAME}' WHERE triggerid=13425;
UPDATE triggers SET description='{HOST.NAME} has just been restarted' WHERE triggerid=13428;
UPDATE triggers SET description='Too many processes on {HOST.NAME}' WHERE triggerid=13430;
UPDATE triggers SET description='Lack of free swap space on {HOST.NAME}' WHERE triggerid=13431;
UPDATE triggers SET description='Lack of free memory on server {HOST.NAME}' WHERE triggerid=13433;
UPDATE triggers SET description='Processor load is too high on {HOST.NAME}' WHERE triggerid=13435;


-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13442','{12830} > ({12831} * 0.7)','70% http-8080 worker threads busy on {HOSTNAME}','','0','2','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13443','{12832} > ({12833} * 0.7)','70% http-8443 worker threads busy on {HOSTNAME}','','0','2','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13444','{12834} > ({12835}  *0.7)','70% jk-8009 worker threads busy on {HOSTNAME}','','0','2','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13445','{12836}>({12837}*0.7)','70% mp CMS Old Gen used on {HOSTNAME}','','0','3','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13446','{12838}>({12839}*0.7)','70% mp CMS Perm Gen used on {HOSTNAME}','','0','3','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13447','{12840}>({12841}*0.7)','70% mp Code Cache used on {HOSTNAME}','','0','3','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13448','{12842}>({12843}*0.7)','70% mp Perm Gen used on {HOSTNAME}','','0','3','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13449','{12844}>({12845}*0.7)','70% mp PS Old Gen used on {HOSTNAME}','','0','3','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13450','{12846}>({12847}*0.7)','70% mp PS Perm Gen used on {HOSTNAME}','','0','3','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13451','{12848}>({12849}*0.7)','70% mp Tenured Gen used on {HOSTNAME}','','0','3','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13452','{12850}>({12851}*0.7)','70% os Opened File Descriptor Count used on {HOSTNAME}','','0','3','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13453','{12852}<{12853}','gc Concurrent Mark Sweep in fire fighting mode on {HOSTNAME}','','0','3','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13454','{12854}<{12855}','gc Mark Sweep Compact in fire fighting mode on {HOSTNAME}','','0','3','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13455','{12856}<{12857}','gc PS Mark Sweep in fire fighting mode on {HOSTNAME}','','0','3','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13456','{12858} = 1','gzip compression is off for connector http-8080 on {HOSTNAME}','','0','1','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13457','{12859} = 1','gzip compression is off for connector http-8443 on {HOSTNAME}','','0','1','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13458','{12860}={12861}','mp CMS Old Gen fully committed on {HOSTNAME}','','0','2','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13459','{12862}={12863}','mp CMS Perm Gen fully committed on {HOSTNAME}','','0','2','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13460','{12864}={12865}','mp Code Cache fully committed on {HOSTNAME}','','0','2','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13461','{12866}={12867}','mp Perm Gen fully committed on {HOSTNAME}','','0','2','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13462','{12868}={12869}','mp PS Old Gen fully committed on {HOSTNAME}','','0','2','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13463','{12870}={12871}','mp PS Perm Gen fully committed on {HOSTNAME}','','0','2','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13464','{12872}={12873}','mp Tenured Gen fully committed on {HOSTNAME}','','0','2','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13465','{12874}=1','{HOSTNAME} is not reachable','','0','3','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13466','{12875}#1','{HOSTNAME} uses suboptimal jit compiler','','0','1','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13507','{12936}>0','Host name of zabbix_agentd was changed on {HOSTNAME}','','0','1','',NULL,'0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('10045','{12927}>0','Version of zabbix_agent(d) was changed on {HOSTNAME}','','0','1','','13026','0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('10047','{12550}=1','Zabbix agent on {HOSTNAME} is unreachable for 5 minutes','','0','3','','13025','0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13288','{12672}=1','Operational status was changed on {HOSTNAME} interface {#SNMPVALUE}','','0','1','','13287','0','2');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13289','{12673}=1','Operational status was changed on {HOSTNAME} interface {#SNMPVALUE}','','0','1','','13287','0','2');


-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13442','{12830} > ({12831} * 0.7)','70% http-8080 worker threads busy on {HOST.NAME}','','0','2','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13443','{12832} > ({12833} * 0.7)','70% http-8443 worker threads busy on {HOST.NAME}','','0','2','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13444','{12834} > ({12835}  *0.7)','70% jk-8009 worker threads busy on {HOST.NAME}','','0','2','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13445','{12836}>({12837}*0.7)','70% mp CMS Old Gen used on {HOST.NAME}','','0','3','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13446','{12838}>({12839}*0.7)','70% mp CMS Perm Gen used on {HOST.NAME}','','0','3','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13447','{12840}>({12841}*0.7)','70% mp Code Cache used on {HOST.NAME}','','0','3','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13448','{12842}>({12843}*0.7)','70% mp Perm Gen used on {HOST.NAME}','','0','3','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13449','{12844}>({12845}*0.7)','70% mp PS Old Gen used on {HOST.NAME}','','0','3','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13450','{12846}>({12847}*0.7)','70% mp PS Perm Gen used on {HOST.NAME}','','0','3','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13451','{12848}>({12849}*0.7)','70% mp Tenured Gen used on {HOST.NAME}','','0','3','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13452','{12850}>({12851}*0.7)','70% os Opened File Descriptor Count used on {HOST.NAME}','','0','3','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13453','{12852}<{12853}','gc Concurrent Mark Sweep in fire fighting mode on {HOST.NAME}','','0','3','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13454','{12854}<{12855}','gc Mark Sweep Compact in fire fighting mode on {HOST.NAME}','','0','3','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13455','{12856}<{12857}','gc PS Mark Sweep in fire fighting mode on {HOST.NAME}','','0','3','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13456','{12858} = 1','gzip compression is off for connector http-8080 on {HOST.NAME}','','0','1','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13457','{12859} = 1','gzip compression is off for connector http-8443 on {HOST.NAME}','','0','1','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13458','{12860}={12861}','mp CMS Old Gen fully committed on {HOST.NAME}','','0','2','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13459','{12862}={12863}','mp CMS Perm Gen fully committed on {HOST.NAME}','','0','2','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13460','{12864}={12865}','mp Code Cache fully committed on {HOST.NAME}','','0','2','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13461','{12866}={12867}','mp Perm Gen fully committed on {HOST.NAME}','','0','2','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13462','{12868}={12869}','mp PS Old Gen fully committed on {HOST.NAME}','','0','2','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13463','{12870}={12871}','mp PS Perm Gen fully committed on {HOST.NAME}','','0','2','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13464','{12872}={12873}','mp Tenured Gen fully committed on {HOST.NAME}','','0','2','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13465','{12874}=1','{HOST.NAME} is not reachable','','0','3','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13466','{12875}#1','{HOST.NAME} uses suboptimal jit compiler','','0','1','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13507','{12936}>0','Host name of zabbix_agentd was changed on {HOST.NAME}','','0','1','',NULL,'0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('10045','{12927}>0','Version of zabbix_agent(d) was changed on {HOST.NAME}','','0','1','','13026','0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('10047','{12550}=1','Zabbix agent on {HOST.NAME} is unreachable for 5 minutes','','0','3','','13025','0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13288','{12672}=1','Operational status was changed on {HOST.NAME} interface {#SNMPVALUE}','','0','1','','13287','0','2');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13289','{12673}=1','Operational status was changed on {HOST.NAME} interface {#SNMPVALUE}','','0','1','','13287','0','2');


UPDATE triggers SET description='70% http-8080 worker threads busy on {HOST.NAME}' WHERE triggerid=13442;
UPDATE triggers SET description='70% http-8443 worker threads busy on {HOST.NAME}' WHERE triggerid=13443;
UPDATE triggers SET description='70% jk-8009 worker threads busy on {HOST.NAME}' WHERE triggerid=13444;
UPDATE triggers SET description='70% mp CMS Old Gen used on {HOST.NAME}' WHERE triggerid=13445;
UPDATE triggers SET description='70% mp CMS Perm Gen used on {HOST.NAME}' WHERE triggerid=13446;
UPDATE triggers SET description='70% mp Code Cache used on {HOST.NAME}' WHERE triggerid=13447;
UPDATE triggers SET description='70% mp Perm Gen used on {HOST.NAME}' WHERE triggerid=13448;
UPDATE triggers SET description='70% mp PS Old Gen used on {HOST.NAME}' WHERE triggerid=13449;
UPDATE triggers SET description='70% mp PS Perm Gen used on {HOST.NAME}' WHERE triggerid=13450;
UPDATE triggers SET description='70% mp Tenured Gen used on {HOST.NAME}' WHERE triggerid=13451;
UPDATE triggers SET description='70% os Opened File Descriptor Count used on {HOST.NAME}' WHERE triggerid=13452;
UPDATE triggers SET description='gc Concurrent Mark Sweep in fire fighting mode on {HOST.NAME}' WHERE triggerid=13453;
UPDATE triggers SET description='gc Mark Sweep Compact in fire fighting mode on {HOST.NAME}' WHERE triggerid=13454;
UPDATE triggers SET description='gc PS Mark Sweep in fire fighting mode on {HOST.NAME}' WHERE triggerid=13455;
UPDATE triggers SET description='gzip compression is off for connector http-8080 on {HOST.NAME}' WHERE triggerid=13456;
UPDATE triggers SET description='gzip compression is off for connector http-8443 on {HOST.NAME}' WHERE triggerid=13457;
UPDATE triggers SET description='mp CMS Old Gen fully committed on {HOST.NAME}' WHERE triggerid=13458;
UPDATE triggers SET description='mp CMS Perm Gen fully committed on {HOST.NAME}' WHERE triggerid=13459;
UPDATE triggers SET description='mp Code Cache fully committed on {HOST.NAME}' WHERE triggerid=13460;
UPDATE triggers SET description='mp Perm Gen fully committed on {HOST.NAME}' WHERE triggerid=13461;
UPDATE triggers SET description='mp PS Old Gen fully committed on {HOST.NAME}' WHERE triggerid=13462;
UPDATE triggers SET description='mp PS Perm Gen fully committed on {HOST.NAME}' WHERE triggerid=13463;
UPDATE triggers SET description='mp Tenured Gen fully committed on {HOST.NAME}' WHERE triggerid=13464;
UPDATE triggers SET description='{HOST.NAME} is not reachable' WHERE triggerid=13465;
UPDATE triggers SET description='{HOST.NAME} uses suboptimal jit compiler' WHERE triggerid=13466;
UPDATE triggers SET description='Host name of zabbix_agentd was changed on {HOST.NAME}' WHERE triggerid=13507;
UPDATE triggers SET description='Version of zabbix_agent(d) was changed on {HOST.NAME}' WHERE triggerid=10045;
UPDATE triggers SET description='Zabbix agent on {HOST.NAME} is unreachable for 5 minutes' WHERE triggerid=10047;
UPDATE triggers SET description='Operational status was changed on {HOST.NAME} interface {#SNMPVALUE}' WHERE triggerid=13288;
UPDATE triggers SET description='Operational status was changed on {HOST.NAME} interface {#SNMPVALUE}' WHERE triggerid=13289;


-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13294','{12681}=1','Operational status was changed on {HOSTNAME} interface {#SNMPVALUE}','','0','1','','13287','0','2');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13328','{12715}=1','Zabbix agent on {HOSTNAME} is unreachable for 5 minutes','','0','3','','13025','0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13329','{12929}>0','Version of zabbix_agent(d) was changed on {HOSTNAME}','','0','1','','13026','0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13344','{12731}=1','Zabbix agent on {HOSTNAME} is unreachable for 5 minutes','','0','3','','13025','0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13345','{12930}>0','Version of zabbix_agent(d) was changed on {HOSTNAME}','','0','1','','13026','0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13360','{12747}=1','Zabbix agent on {HOSTNAME} is unreachable for 5 minutes','','0','3','','13025','0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13361','{12931}>0','Version of zabbix_agent(d) was changed on {HOSTNAME}','','0','1','','13026','0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13376','{12763}=1','Zabbix agent on {HOSTNAME} is unreachable for 5 minutes','','0','3','','13025','0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13377','{12932}>0','Version of zabbix_agent(d) was changed on {HOSTNAME}','','0','1','','13026','0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13392','{12779}=1','Zabbix agent on {HOSTNAME} is unreachable for 5 minutes','','0','3','','13025','0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13393','{12933}>0','Version of zabbix_agent(d) was changed on {HOSTNAME}','','0','1','','13026','0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13408','{12795}=1','Zabbix agent on {HOSTNAME} is unreachable for 5 minutes','','0','3','','13025','0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13409','{12934}>0','Version of zabbix_agent(d) was changed on {HOSTNAME}','','0','1','','13026','0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13437','{12824}=1','Zabbix agent on {HOSTNAME} is unreachable for 5 minutes','','0','3','','13025','0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13438','{12935}>0','Version of zabbix_agent(d) was changed on {HOSTNAME}','','0','1','','13026','0','0');

-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13294','{12681}=1','Operational status was changed on {HOST.NAME} interface {#SNMPVALUE}','','0','1','','13287','0','2');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13328','{12715}=1','Zabbix agent on {HOST.NAME} is unreachable for 5 minutes','','0','3','','13025','0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13329','{12929}>0','Version of zabbix_agent(d) was changed on {HOST.NAME}','','0','1','','13026','0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13344','{12731}=1','Zabbix agent on {HOST.NAME} is unreachable for 5 minutes','','0','3','','13025','0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13345','{12930}>0','Version of zabbix_agent(d) was changed on {HOST.NAME}','','0','1','','13026','0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13360','{12747}=1','Zabbix agent on {HOST.NAME} is unreachable for 5 minutes','','0','3','','13025','0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13361','{12931}>0','Version of zabbix_agent(d) was changed on {HOST.NAME}','','0','1','','13026','0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13376','{12763}=1','Zabbix agent on {HOST.NAME} is unreachable for 5 minutes','','0','3','','13025','0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13377','{12932}>0','Version of zabbix_agent(d) was changed on {HOST.NAME}','','0','1','','13026','0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13392','{12779}=1','Zabbix agent on {HOST.NAME} is unreachable for 5 minutes','','0','3','','13025','0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13393','{12933}>0','Version of zabbix_agent(d) was changed on {HOST.NAME}','','0','1','','13026','0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13408','{12795}=1','Zabbix agent on {HOST.NAME} is unreachable for 5 minutes','','0','3','','13025','0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13409','{12934}>0','Version of zabbix_agent(d) was changed on {HOST.NAME}','','0','1','','13026','0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13437','{12824}=1','Zabbix agent on {HOST.NAME} is unreachable for 5 minutes','','0','3','','13025','0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13438','{12935}>0','Version of zabbix_agent(d) was changed on {HOST.NAME}','','0','1','','13026','0','0');


UPDATE triggers SET description='Operational status was changed on {HOST.NAME} interface {#SNMPVALUE}' WHERE triggerid=13294;
UPDATE triggers SET description='Zabbix agent on {HOST.NAME} is unreachable for 5 minutes' WHERE triggerid=13328;
UPDATE triggers SET description='Version of zabbix_agent(d) was changed on {HOST.NAME}' WHERE triggerid=13329;
UPDATE triggers SET description='Zabbix agent on {HOST.NAME} is unreachable for 5 minutes' WHERE triggerid=13344;
UPDATE triggers SET description='Version of zabbix_agent(d) was changed on {HOST.NAME}' WHERE triggerid=13345;
UPDATE triggers SET description='Zabbix agent on {HOST.NAME} is unreachable for 5 minutes' WHERE triggerid=13360;
UPDATE triggers SET description='Version of zabbix_agent(d) was changed on {HOST.NAME}' WHERE triggerid=13361;
UPDATE triggers SET description='Zabbix agent on {HOST.NAME} is unreachable for 5 minutes' WHERE triggerid=13376;
UPDATE triggers SET description='Version of zabbix_agent(d) was changed on {HOST.NAME}' WHERE triggerid=13377;
UPDATE triggers SET description='Zabbix agent on {HOST.NAME} is unreachable for 5 minutes' WHERE triggerid=13392;
UPDATE triggers SET description='Version of zabbix_agent(d) was changed on {HOST.NAME}' WHERE triggerid=13393;
UPDATE triggers SET description='Zabbix agent on {HOST.NAME} is unreachable for 5 minutes' WHERE triggerid=13408;
UPDATE triggers SET description='Version of zabbix_agent(d) was changed on {HOST.NAME}' WHERE triggerid=13409;
UPDATE triggers SET description='Zabbix agent on {HOST.NAME} is unreachable for 5 minutes' WHERE triggerid=13437;
UPDATE triggers SET description='Version of zabbix_agent(d) was changed on {HOST.NAME}' WHERE triggerid=13438;


-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13491','{12900}=1','Zabbix agent on {HOSTNAME} is unreachable for 5 minutes','','0','3','','10047','0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13492','{12928}>0','Version of zabbix_agent(d) was changed on {HOSTNAME}','','0','1','','10045','0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13493','{12902}<1024','Configured max number of opened files is too low on {HOSTNAME}','','0','1','','10042','0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13494','{12903}<256','Configured max number of processes is too low on {HOSTNAME}','','0','1','','10041','0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13495','{12904}>30','Too many processes running on {HOSTNAME}','','0','2','','10011','0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13496','{12905}>300','Too many processes on {HOSTNAME}','','0','2','','10190','0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13497','{12906}>5','Processor load is too high on {HOSTNAME}','','0','2','','10010','0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13498','{12907}>20','Disk I/O is overloaded on {HOSTNAME}','','0','2','OS spends significant time waiting for I/O (input/output) operations. It could be indicator of performance issues with storage system.','13243','0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13499','{12908}>0','Hostname was changed on {HOSTNAME}','','0','1','','10043','0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13500','{12909}<50','Lack of free swap space on {HOSTNAME}','','0','2','It probably means that the systems requires more physical memory.','10012','0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13501','{12910}>0','Host information was changed on {HOSTNAME}','','0','1','','10044','0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13502','{12911}<0','{HOSTNAME} has just been restarted','','0','1','','10021','0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13503','{12912}>0','/etc/passwd has been changed on {HOSTNAME}','','0','2','','10016','0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13504','{12913}<20M','Lack of available memory on server {HOSTNAME}','','0','3','','13000','0','0');

-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13491','{12900}=1','Zabbix agent on {HOST.NAME} is unreachable for 5 minutes','','0','3','','10047','0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13492','{12928}>0','Version of zabbix_agent(d) was changed on {HOST.NAME}','','0','1','','10045','0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13493','{12902}<1024','Configured max number of opened files is too low on {HOST.NAME}','','0','1','','10042','0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13494','{12903}<256','Configured max number of processes is too low on {HOST.NAME}','','0','1','','10041','0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13495','{12904}>30','Too many processes running on {HOST.NAME}','','0','2','','10011','0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13496','{12905}>300','Too many processes on {HOST.NAME}','','0','2','','10190','0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13497','{12906}>5','Processor load is too high on {HOST.NAME}','','0','2','','10010','0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13498','{12907}>20','Disk I/O is overloaded on {HOST.NAME}','','0','2','OS spends significant time waiting for I/O (input/output) operations. It could be indicator of performance issues with storage system.','13243','0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13499','{12908}>0','Hostname was changed on {HOST.NAME}','','0','1','','10043','0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13500','{12909}<50','Lack of free swap space on {HOST.NAME}','','0','2','It probably means that the systems requires more physical memory.','10012','0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13501','{12910}>0','Host information was changed on {HOST.NAME}','','0','1','','10044','0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13502','{12911}<0','{HOST.NAME} has just been restarted','','0','1','','10021','0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13503','{12912}>0','/etc/passwd has been changed on {HOST.NAME}','','0','2','','10016','0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13504','{12913}<20M','Lack of available memory on server {HOST.NAME}','','0','3','','13000','0','0');


UPDATE triggers SET description='Zabbix agent on {HOST.NAME} is unreachable for 5 minutes' WHERE triggerid=13491;
UPDATE triggers SET description='Version of zabbix_agent(d) was changed on {HOST.NAME}' WHERE triggerid=13492;
UPDATE triggers SET description='Configured max number of opened files is too low on {HOST.NAME}' WHERE triggerid=13493;
UPDATE triggers SET description='Configured max number of processes is too low on {HOST.NAME}' WHERE triggerid=13494;
UPDATE triggers SET description='Too many processes running on {HOST.NAME}' WHERE triggerid=13495;
UPDATE triggers SET description='Too many processes on {HOST.NAME}' WHERE triggerid=13496;
UPDATE triggers SET description='Processor load is too high on {HOST.NAME}' WHERE triggerid=13497;
UPDATE triggers SET description='Disk I/O is overloaded on {HOST.NAME}' WHERE triggerid=13498;
UPDATE triggers SET description='Hostname was changed on {HOST.NAME}' WHERE triggerid=13499;
UPDATE triggers SET description='Lack of free swap space on {HOST.NAME}' WHERE triggerid=13500;
UPDATE triggers SET description='Host information was changed on {HOST.NAME}' WHERE triggerid=13501;
UPDATE triggers SET description='{HOST.NAME} has just been restarted' WHERE triggerid=13502;
UPDATE triggers SET description='/etc/passwd has been changed on {HOST.NAME}' WHERE triggerid=13503;
UPDATE triggers SET description='Lack of available memory on server {HOST.NAME}' WHERE triggerid=13504;


-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13508','{12937}>0','Host name of zabbix_agentd was changed on {HOSTNAME}','','0','1','','13507','0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13509','{12938}>0','Host name of zabbix_agentd was changed on {HOSTNAME}','','0','1','','13508','0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13510','{12939}>0','Host name of zabbix_agentd was changed on {HOSTNAME}','','0','1','','13507','0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13511','{12940}>0','Host name of zabbix_agentd was changed on {HOSTNAME}','','0','1','','13507','0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13512','{12941}>0','Host name of zabbix_agentd was changed on {HOSTNAME}','','0','1','','13507','0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13513','{12942}>0','Host name of zabbix_agentd was changed on {HOSTNAME}','','0','1','','13507','0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13514','{12943}>0','Host name of zabbix_agentd was changed on {HOSTNAME}','','0','1','','13507','0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13515','{12944}>0','Host name of zabbix_agentd was changed on {HOSTNAME}','','0','1','','13507','0','0');
-- -INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13516','{12945}>0','Host name of zabbix_agentd was changed on {HOSTNAME}','','0','1','','13507','0','0');

-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13508','{12937}>0','Host name of zabbix_agentd was changed on {HOST.NAME}','','0','1','','13507','0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13509','{12938}>0','Host name of zabbix_agentd was changed on {HOST.NAME}','','0','1','','13508','0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13510','{12939}>0','Host name of zabbix_agentd was changed on {HOST.NAME}','','0','1','','13507','0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13511','{12940}>0','Host name of zabbix_agentd was changed on {HOST.NAME}','','0','1','','13507','0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13512','{12941}>0','Host name of zabbix_agentd was changed on {HOST.NAME}','','0','1','','13507','0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13513','{12942}>0','Host name of zabbix_agentd was changed on {HOST.NAME}','','0','1','','13507','0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13514','{12943}>0','Host name of zabbix_agentd was changed on {HOST.NAME}','','0','1','','13507','0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13515','{12944}>0','Host name of zabbix_agentd was changed on {HOST.NAME}','','0','1','','13507','0','0');
-- +INSERT INTO triggers (triggerid,expression,description,url,status,priority,comments,templateid,type,flags) values ('13516','{12945}>0','Host name of zabbix_agentd was changed on {HOST.NAME}','','0','1','','13507','0','0');


UPDATE triggers SET description='Host name of zabbix_agentd was changed on {HOST.NAME}' WHERE triggerid=13508;
UPDATE triggers SET description='Host name of zabbix_agentd was changed on {HOST.NAME}' WHERE triggerid=13509;
UPDATE triggers SET description='Host name of zabbix_agentd was changed on {HOST.NAME}' WHERE triggerid=13510;
UPDATE triggers SET description='Host name of zabbix_agentd was changed on {HOST.NAME}' WHERE triggerid=13511;
UPDATE triggers SET description='Host name of zabbix_agentd was changed on {HOST.NAME}' WHERE triggerid=13512;
UPDATE triggers SET description='Host name of zabbix_agentd was changed on {HOST.NAME}' WHERE triggerid=13513;
UPDATE triggers SET description='Host name of zabbix_agentd was changed on {HOST.NAME}' WHERE triggerid=13514;
UPDATE triggers SET description='Host name of zabbix_agentd was changed on {HOST.NAME}' WHERE triggerid=13515;
UPDATE triggers SET description='Host name of zabbix_agentd was changed on {HOST.NAME}' WHERE triggerid=13516;


COMMIT;
