START TRANSACTION;
-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','net.dns.record[&lt;ip&gt;,&lt;zone&gt;,&lt;type&gt;,&lt;timeout&gt;,&lt;count&gt;]','Performs a DNS query. On success returns a character string with the required type of information.');
-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','net.dns[&lt;ip&gt;,&lt;zone&gt;,&lt;type&gt;,&lt;timeout&gt;,&lt;count&gt;]','Checks if DNS service is up. 0 - DNS is down (server did not respond or DNS resolution failed), 1 - DNS is up.');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','net.dns.record[&lt;ip&gt;,zone,&lt;type&gt;,&lt;timeout&gt;,&lt;count&gt;]','Performs a DNS query. On success returns a character string with the required type of information.');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','net.dns[&lt;ip&gt;,zone,&lt;type&gt;,&lt;timeout&gt;,&lt;count&gt;]','Checks if DNS service is up. 0 - DNS is down (server did not respond or DNS resolution failed), 1 - DNS is up.');

UPDATE `help_items` SET `key_`='net.dns.record[&lt;ip&gt;,zone,&lt;type&gt;,&lt;timeout&gt;,&lt;count&gt;]'
  WHERE `itemtype`='0' AND `key_`='net.dns.record[&lt;ip&gt;,&lt;zone&gt;,&lt;type&gt;,&lt;timeout&gt;,&lt;count&gt;]';
UPDATE `help_items` SET `key_`='net.dns[&lt;ip&gt;,zone,&lt;type&gt;,&lt;timeout&gt;,&lt;count&gt;]'
  WHERE `itemtype`='0' AND `key_`='net.dns[&lt;ip&gt;,&lt;zone&gt;,&lt;type&gt;,&lt;timeout&gt;,&lt;count&gt;]';

-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','net.if.in[if &lt;,mode&gt;]','Network interface input statistic. Integer value. If mode is missing bytes is used.');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','net.if.in[if,&lt;mode&gt;]','Network interface input statistic. Integer value. If mode is missing bytes is used.');

UPDATE `help_items` SET `key_`='net.if.in[if,&lt;mode&gt;]'
  WHERE `itemtype`='0' AND `key_`='net.if.in[if &lt;,mode&gt;]';

-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','net.if.out[if &lt;,mode&gt;]','Network interface output statistic. Integer value. If mode is missing bytes is used.');
-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','net.if.total[if &lt;,mode&gt;]','Sum of network interface incoming and outgoing statistics. Integer value. Mode - one of bytes (default), packets, errors or dropped');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','net.if.out[if,&lt;mode&gt;]','Network interface output statistic. Integer value. If mode is missing bytes is used.');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','net.if.total[if,&lt;mode&gt;]','Sum of network interface incoming and outgoing statistics. Integer value. Mode - one of bytes (default), packets, errors or dropped');

UPDATE `help_items` SET `key_`='net.if.out[if,&lt;mode&gt;]'
  WHERE `itemtype`='0' AND `key_`='net.if.out[if &lt;,mode&gt;]';
UPDATE `help_items` SET `key_`='net.if.total[if,&lt;mode&gt;]'
  WHERE `itemtype`='0' AND `key_`='net.if.total[if &lt;,mode&gt;]';


-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','net.tcp.port[&lt;ip&gt;, port]','Check, if it is possible to make TCP connection to the port number. 0 - cannot connect, 1 - can connect. IP address is optional. If ip is missing, 127.0.0.1 is used. Example: net.tcp.port[,80]');
-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','net.tcp.service.perf[service &lt;,ip&gt; &lt;,port&gt;]','Check performance of service &quot;service&quot;. 0 - service is down, sec - number of seconds spent on connection to the service. If ip is missing 127.0.0.1 is used.  If port number is missing, default service port is used.');
-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','net.tcp.service[service &lt;,ip&gt; &lt;,port&gt;]','Check if service is available. 0 - service is down, 1 - service is running. If ip is missing 127.0.0.1 is used. If port number is missing, default service port is used. Example: net.tcp.service[ftp,,45].');
-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','perf_counter[counter, interval]','Value of any performance counter, where "counter" parameter is the counter path and "interval" parameter is a number of last seconds, for which the agent returns an average value.');
-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','proc.mem[&lt;name&gt; &lt;,user&gt; &lt;,mode&gt; &lt;,cmdline&gt;]','Memory used by process with name name running under user user. Memory used by processes. Process name, user and mode is optional. If name or user is missing all processes will be calculated. If mode is missing sum is used. Example: proc.mem[,root]');
-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','proc.num[&lt;name&gt; &lt;,user&gt; &lt;,state&gt; &lt;,cmdline&gt;]','Number of processes with name name running under user user having state state. Process name, user and state are optional. Examples: proc.num[,mysql]; proc.num[apache2,www-data]; proc.num[,oracle,sleep,oracleZABBIX]');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','net.tcp.port[&lt;ip&gt;,port]','Check, if it is possible to make TCP connection to the port number. 0 - cannot connect, 1 - can connect. IP address is optional. If ip is missing, 127.0.0.1 is used. Example: net.tcp.port[,80]');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','net.tcp.service.perf[service,&lt;ip&gt;,&lt;port&gt;]','Check performance of service &quot;service&quot;. 0 - service is down, sec - number of seconds spent on connection to the service. If ip is missing 127.0.0.1 is used.  If port number is missing, default service port is used.');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','net.tcp.service[service,&lt;ip&gt;,&lt;port&gt;]','Check if service is available. 0 - service is down, 1 - service is running. If ip is missing 127.0.0.1 is used. If port number is missing, default service port is used. Example: net.tcp.service[ftp,,45].');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','perf_counter[counter,&lt;interval&gt;]','Value of any performance counter, where "counter" parameter is the counter path and "interval" parameter is a number of last seconds, for which the agent returns an average value.');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','proc.mem[&lt;name&gt;,&lt;user&gt;,&lt;mode&gt;,&lt;cmdline&gt;]','Memory used by process with name name running under user user. Memory used by processes. Process name, user and mode is optional. If name or user is missing all processes will be calculated. If mode is missing sum is used. Example: proc.mem[,root]');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','proc.num[&lt;name&gt;,&lt;user&gt;,&lt;state&gt;,&lt;cmdline&gt;]','Number of processes with name name running under user user having state state. Process name, user and state are optional. Examples: proc.num[,mysql]; proc.num[apache2,www-data]; proc.num[,oracle,sleep,oracleZABBIX]');

UPDATE `help_items` SET `key_`='net.tcp.port[&lt;ip&gt;,port]'
  WHERE `itemtype`='0' AND `key_`='net.tcp.port[&lt;ip&gt;, port]';
UPDATE `help_items` SET `key_`='net.tcp.service.perf[service,&lt;ip&gt;,&lt;port&gt;]'
  WHERE `itemtype`='0' AND `key_`='net.tcp.service.perf[service &lt;,ip&gt; &lt;,port&gt;]';
UPDATE `help_items` SET `key_`='net.tcp.service[service,&lt;ip&gt;,&lt;port&gt;]'
  WHERE `itemtype`='0' AND `key_`='net.tcp.service[service &lt;,ip&gt; &lt;,port&gt;]';
UPDATE `help_items` SET `key_`='perf_counter[counter,&lt;interval&gt;]'
  WHERE `itemtype`='0' AND `key_`='perf_counter[counter, interval]';
UPDATE `help_items` SET `key_`='proc.mem[&lt;name&gt;,&lt;user&gt;,&lt;mode&gt;,&lt;cmdline&gt;]'
  WHERE `itemtype`='0' AND `key_`='proc.mem[&lt;name&gt; &lt;,user&gt; &lt;,mode&gt; &lt;,cmdline&gt;]';
UPDATE `help_items` SET `key_`='proc.num[&lt;name&gt;,&lt;user&gt;,&lt;state&gt;,&lt;cmdline&gt;]'
  WHERE `itemtype`='0' AND `key_`='proc.num[&lt;name&gt; &lt;,user&gt; &lt;,state&gt; &lt;,cmdline&gt;]';

-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','system.cpu.load[&lt;cpu&gt; &lt;,mode&gt;]','CPU(s) load. Processor load. The cpu and mode are optional. If cpu is missing all is used. If mode is missing avg1 is used. Note that this is not percentage.');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','system.cpu.load[&lt;cpu&gt;,&lt;mode&gt;]','CPU(s) load. Processor load. The cpu and mode are optional. If cpu is missing all is used. If mode is missing avg1 is used. Note that this is not percentage.');

UPDATE `help_items` SET `key_`='system.cpu.load[&lt;cpu&gt;,&lt;mode&gt;]'
  WHERE `itemtype`='0' AND `key_`='system.cpu.load[&lt;cpu&gt; &lt;,mode&gt;]';

-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','system.cpu.util[&lt;cpu&gt; &lt;,type&gt; &lt;,mode&gt;]','CPU(s) utilisation. Processor load in percents. The cpu, type and mode are optional. If cpu is missing all is used.  If type is missing user is used. If mode is missing avg1 is used.');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','system.cpu.util[&lt;cpu&gt;,&lt;type&gt;,&lt;mode&gt;]','CPU(s) utilisation. Processor load in percents. The cpu, type and mode are optional. If cpu is missing all is used.  If type is missing user is used. If mode is missing avg1 is used.');

UPDATE `help_items` SET `key_`='system.cpu.util[&lt;cpu&gt;,&lt;type&gt;,&lt;mode&gt;]'
  WHERE `itemtype`='0' AND `key_`='system.cpu.util[&lt;cpu&gt; &lt;,type&gt; &lt;,mode&gt;]';

-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','system.run[command,&lt;mode&gt]','Run specified command on the host.');
-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','system.stat[resource &lt;,type&gt;]','Virtual memory statistics.');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','system.run[command,&lt;mode&gt;]','Run specified command on the host.');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','system.stat[resource,&lt;type&gt;]','Virtual memory statistics.');

UPDATE `help_items` SET `key_`='system.run[command,&lt;mode&gt;]'
  WHERE `itemtype`='0' AND `key_`='system.run[command,&lt;mode&gt]';
UPDATE `help_items` SET `key_`='system.stat[resource,&lt;type&gt;]'
  WHERE `itemtype`='0' AND `key_`='system.stat[resource &lt;,type&gt;]';


-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','system.swap.in[&lt;swap&gt; &lt;,type&gt;]','Swap in. If type is count - swapins is returned. If type is pages - pages swapped in is returned. If swap is missing all is used.');
-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','system.swap.out[&lt;swap&gt; &lt;,type&gt;]','Swap out. If type is count - swapouts is returned. If type is pages - pages swapped in is returned. If swap is missing all is used.');
-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','system.swap.size[&lt;swap&gt; &lt;,mode&gt;]','Swap space. Number of bytes. If swap is missing all is used. If mode is missing free is used.');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','system.swap.in[&lt;swap&gt;,&lt;type&gt;]','Swap in. If type is count - swapins is returned. If type is pages - pages swapped in is returned. If swap is missing all is used.');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','system.swap.out[&lt;swap&gt;,&lt;type&gt;]','Swap out. If type is count - swapouts is returned. If type is pages - pages swapped in is returned. If swap is missing all is used.');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','system.swap.size[&lt;swap&gt;,&lt;mode&gt;]','Swap space. Number of bytes. If swap is missing all is used. If mode is missing free is used.');

UPDATE `help_items` SET `key_`='system.swap.in[&lt;swap&gt;,&lt;type&gt;]'
  WHERE `itemtype`='0' AND `key_`='system.swap.in[&lt;swap&gt; &lt;,type&gt;]';
UPDATE `help_items` SET `key_`='system.swap.out[&lt;swap&gt;,&lt;type&gt;]'
  WHERE `itemtype`='0' AND `key_`='system.swap.out[&lt;swap&gt; &lt;,type&gt;]';
UPDATE `help_items` SET `key_`='system.swap.size[&lt;swap&gt;,&lt;mode&gt;]'
  WHERE `itemtype`='0' AND `key_`='system.swap.size[&lt;swap&gt; &lt;,mode&gt;]';

-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','vfs.dev.read[device &lt;,type&gt; &lt;,mode&gt;]','Device read statistics.');
-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','vfs.dev.write[device &lt;,type&gt; &lt;,mode&gt;]','Device write statistics.');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','vfs.dev.read[device,&lt;type&gt;,&lt;mode&gt;]','Device read statistics.');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','vfs.dev.write[device,&lt;type&gt;,&lt;mode&gt;]','Device write statistics.');

UPDATE `help_items` SET `key_`='vfs.dev.read[device,&lt;type&gt;,&lt;mode&gt;]'
  WHERE `itemtype`='0' AND `key_`='vfs.dev.read[device &lt;,type&gt; &lt;,mode&gt;]';
UPDATE `help_items` SET `key_`='vfs.dev.write[device,&lt;type&gt;,&lt;mode&gt;]'
  WHERE `itemtype`='0' AND `key_`='vfs.dev.write[device &lt;,type&gt; &lt;,mode&gt;]';

INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','vfs.file.contents[file,&lt;encoding&gt;]','Get contents of a given file.');


-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','vfs.file.md5sum[file]','Calculate MD5 check sum of a given file. String MD5 hash of the file. Can be used for files less than 64MB, unsupported otherwise. Example: vfs.file.md5sum[/etc/zabbix/zabbix_agentd.conf]');
-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','vfs.file.regexp[file,regexp]','Find string in a file. Matched string');
-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','vfs.file.regmatch[file,regexp]','Find string in a file. 0 - expression not found, 1 - found');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','vfs.file.md5sum[file]','Calculate MD5 check sum of a given file. String MD5 hash of the file. Can be used for files less than 64MB, unsupported otherwise. Example: vfs.file.md5sum[/usr/local/etc/zabbix_agentd.conf]');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','vfs.file.regexp[file,regexp,&lt;encoding&gt;]','Find string in a file. Matched string');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','vfs.file.regmatch[file,regexp,&lt;encoding&gt;]','Find string in a file. 0 - expression not found, 1 - found');

UPDATE `help_items` SET `description`='Calculate MD5 check sum of a given file. String MD5 hash of the file. Can be used for files less than 64MB, unsupported otherwise. Example: vfs.file.md5sum[/usr/local/etc/zabbix_agentd.conf]'
  WHERE `itemtype`='0' AND `description`='Calculate MD5 check sum of a given file. String MD5 hash of the file. Can be used for files less than 64MB, unsupported otherwise. Example: vfs.file.md5sum[/etc/zabbix/zabbix_agentd.conf]';
UPDATE `help_items` SET `key_`='vfs.file.regexp[file,regexp,&lt;encoding&gt;]'
  WHERE `itemtype`='0' AND `key_`='vfs.file.regexp[file,regexp]';
UPDATE `help_items` SET `key_`='vfs.file.regmatch[file,regexp,&lt;encoding&gt;]'
  WHERE `itemtype`='0' AND `key_`='vfs.file.regmatch[file,regexp]';

-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','vfs.file.time[file &lt;,mode&gt;]','File time information. Number of seconds.The mode is optional. If mode is missing modify is used.');
-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','vfs.fs.inode[fs &lt;,mode&gt;]','Number of inodes for a given volume. If mode is missing total is used.');
-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','vfs.fs.size[fs &lt;,mode&gt;]','Calculate disk space for a given volume. Disk space in KB. If mode is missing total is used.  In case of mounted volume, unused disk space for local file system is returned. Example: vfs.fs.size[/tmp,free].');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','vfs.file.time[file,&lt;mode&gt;]','File time information. Number of seconds.The mode is optional. If mode is missing modify is used.');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','vfs.fs.inode[fs,&lt;mode&gt;]','Number of inodes for a given volume. If mode is missing total is used.');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('0','vfs.fs.size[fs,&lt;mode&gt;]','Calculate disk space for a given volume. Disk space in KB. If mode is missing total is used.  In case of mounted volume, unused disk space for local file system is returned. Example: vfs.fs.size[/tmp,free].');

UPDATE `help_items` SET `key_`='vfs.file.time[file,&lt;mode&gt;]'
  WHERE `itemtype`='0' AND `key_`='vfs.file.time[file &lt;,mode&gt;]';
UPDATE `help_items` SET `key_`='vfs.fs.inode[fs,&lt;mode&gt;]'
  WHERE `itemtype`='0' AND `key_`='vfs.fs.inode[fs &lt;,mode&gt;]';
UPDATE `help_items` SET `key_`='vfs.fs.size[fs,&lt;mode&gt;]'
  WHERE `itemtype`='0' AND `key_`='vfs.fs.size[fs &lt;,mode&gt;]';

-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('3','icmppingloss[&lt;ip&gt;,&lt;count&gt;,&lt;interval&gt;,&lt;size&gt;,&lt;timeout&gt;]','Returns percentage of lost ICMP ping packets.');
-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('3','icmppingsec[&lt;ip&gt;,&lt;count&gt;,&lt;interval&gt;,&lt;size&gt;,&lt;timeout&gt;,&lt;type&gt;]','Returns ICMP ping response time in seconds. Example: 0.02');
-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('3','icmpping[&lt;ip&gt;,&lt;count&gt;,&lt;interval&gt;,&lt;size&gt;,&lt;timeout&gt;]','Checks if server is accessible by ICMP ping. 0 - ICMP ping fails. 1 - ICMP ping successful. One of zabbix_server processes performs ICMP pings once per PingerFrequency seconds.');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('3','icmppingloss[&lt;target&gt;,&lt;packets&gt;,&lt;interval&gt;,&lt;size&gt;,&lt;timeout&gt;]','Returns percentage of lost ICMP ping packets.');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('3','icmppingsec[&lt;target&gt;,&lt;packets&gt;,&lt;interval&gt;,&lt;size&gt;,&lt;timeout&gt;,&lt;mode&gt;]','Returns ICMP ping response time in seconds. Example: 0.02');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('3','icmpping[&lt;target&gt;,&lt;packets&gt;,&lt;interval&gt;,&lt;size&gt;,&lt;timeout&gt;]','Checks if server is accessible by ICMP ping. 0 - ICMP ping fails. 1 - ICMP ping successful. One of zabbix_server processes performs ICMP pings once per PingerFrequency seconds.');

UPDATE `help_items` SET `key_`='icmppingloss[&lt;target&gt;,&lt;packets&gt;,&lt;interval&gt;,&lt;size&gt;,&lt;timeout&gt;]'
  WHERE `itemtype`='3' AND `key_`='icmppingloss[&lt;ip&gt;,&lt;count&gt;,&lt;interval&gt;,&lt;size&gt;,&lt;timeout&gt;]';
UPDATE `help_items` SET `key_`='icmppingsec[&lt;target&gt;,&lt;packets&gt;,&lt;interval&gt;,&lt;size&gt;,&lt;timeout&gt;,&lt;mode&gt;]'
  WHERE `itemtype`='3' AND `key_`='icmppingsec[&lt;ip&gt;,&lt;count&gt;,&lt;interval&gt;,&lt;size&gt;,&lt;timeout&gt;,&lt;type&gt;]';
UPDATE `help_items` SET `key_`='icmpping[&lt;target&gt;,&lt;packets&gt;,&lt;interval&gt;,&lt;size&gt;,&lt;timeout&gt;]'
  WHERE `itemtype`='3' AND `key_`='icmpping[&lt;ip&gt;,&lt;count&gt;,&lt;interval&gt;,&lt;size&gt;,&lt;timeout&gt;]';

INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('5','zabbix[host,&lt;type&gt;,available]','Returns availability of a particular type of checks on the host. Value of this item corresponds to availability icons in the host list. Valid types are: agent, snmp, ipmi, jmx.');
INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('5','zabbix[java,,&lt;param&gt;]','Returns information associated with Zabbix Java gateway. Valid params are: ping, version.');


-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('5','zabbix[queue&lt;,from&gt;&lt;,to&gt;]','Number of items in the queue which are delayed by from to to seconds, inclusive.');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('5','zabbix[queue,&lt;from&gt;,&lt;to&gt;]','Number of items in the queue which are delayed by from to to seconds, inclusive.');

UPDATE `help_items` SET `key_`='zabbix[queue,&lt;from&gt;,&lt;to&gt;]'
  WHERE `itemtype`='5' AND `key_`='zabbix[queue&lt;,from&gt;&lt;,to&gt;]';

INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('5','zabbix[requiredperformance]','Required performance of the Zabbix server, in new values per second expected.');


-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','net.dns.record[&lt;ip&gt;,&lt;zone&gt;,&lt;type&gt;,&lt;timeout&gt;,&lt;count&gt;]','Performs a DNS query. On success returns a character string with the required type of information.');
-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','net.dns[&lt;ip&gt;,&lt;zone&gt;,&lt;type&gt;,&lt;timeout&gt;,&lt;count&gt;]','Checks if DNS service is up. 0 - DNS is down (server did not respond or DNS resolution failed), 1 - DNS is up.');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','net.dns.record[&lt;ip&gt;,zone,&lt;type&gt;,&lt;timeout&gt;,&lt;count&gt;]','Performs a DNS query. On success returns a character string with the required type of information.');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','net.dns[&lt;ip&gt;,zone,&lt;type&gt;,&lt;timeout&gt;,&lt;count&gt;]','Checks if DNS service is up. 0 - DNS is down (server did not respond or DNS resolution failed), 1 - DNS is up.');

UPDATE `help_items` SET `key_`='net.dns.record[&lt;ip&gt;,zone,&lt;type&gt;,&lt;timeout&gt;,&lt;count&gt;]'
  WHERE `itemtype`='7' AND `key_`='net.dns.record[&lt;ip&gt;,&lt;zone&gt;,&lt;type&gt;,&lt;timeout&gt;,&lt;count&gt;]';
UPDATE `help_items` SET `key_`='net.dns[&lt;ip&gt;,zone,&lt;type&gt;,&lt;timeout&gt;,&lt;count&gt;]'
  WHERE `itemtype`='7' AND `key_`='net.dns[&lt;ip&gt;,&lt;zone&gt;,&lt;type&gt;,&lt;timeout&gt;,&lt;count&gt;]';

-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','net.if.in[if &lt;,mode&gt;]','Network interface input statistic. Integer value. If mode is missing bytes is used.');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','net.if.in[if,&lt;mode&gt;]','Network interface input statistic. Integer value. If mode is missing bytes is used.');

UPDATE `help_items` SET `key_`='net.if.in[if,&lt;mode&gt;]'
  WHERE `itemtype`='7' AND `key_`='net.if.in[if &lt;,mode&gt;]';

-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','net.if.out[if &lt;,mode&gt;]','Network interface output statistic. Integer value. If mode is missing bytes is used.');
-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','net.if.total[if &lt;,mode&gt;]','Sum of network interface incoming and outgoing statistics. Integer value. Mode - one of bytes (default), packets, errors or dropped');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','net.if.out[if,&lt;mode&gt;]','Network interface output statistic. Integer value. If mode is missing bytes is used.');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','net.if.total[if,&lt;mode&gt;]','Sum of network interface incoming and outgoing statistics. Integer value. Mode - one of bytes (default), packets, errors or dropped');

UPDATE `help_items` SET `key_`='net.if.out[if,&lt;mode&gt;]'
  WHERE `itemtype`='7' AND `key_`='net.if.out[if &lt;,mode&gt;]';
UPDATE `help_items` SET `key_`='net.if.total[if,&lt;mode&gt;]'
  WHERE `itemtype`='7' AND `key_`='net.if.total[if &lt;,mode&gt;]';

-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','net.tcp.port[&lt;ip&gt;, port]','Check, if it is possible to make TCP connection to the port number. 0 - cannot connect, 1 - can connect. IP address is optional. If ip is missing, 127.0.0.1 is used. Example: net.tcp.port[,80]');
-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','net.tcp.service.perf[service &lt;,ip&gt; &lt;,port&gt;]','Check performance of service &quot;service&quot;. 0 - service is down, sec - number of seconds spent on connection to the service. If ip is missing 127.0.0.1 is used.  If port number is missing, default service port is used.');
-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','net.tcp.service[service &lt;,ip&gt; &lt;,port&gt;]','Check if service is available. 0 - service is down, 1 - service is running. If ip is missing 127.0.0.1 is used. If port number is missing, default service port is used. Example: net.tcp.service[ftp,,45].');
-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','perf_counter[counter]','Value of any performance counter, where parameter is the counter path.');
-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','proc.mem[&lt;name&gt; &lt;,user&gt; &lt;,mode&gt; &lt;,cmdline&gt;]','Memory used by process with name name running under user user. Memory used by processes. Process name, user and mode is optional. If name or user is missing all processes will be calculated. If mode is missing sum is used. Example: proc.mem[,root]');
-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','proc.num[&lt;name&gt; &lt;,user&gt; &lt;,state&gt; &lt;,cmdline&gt;]','Number of processes with name name running under user user having state state. Process name, user and state are optional. Examples: proc.num[,mysql]; proc.num[apache2,www-data]; proc.num[,oracle,sleep,oracleZABBIX]');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','net.tcp.port[&lt;ip&gt;,port]','Check, if it is possible to make TCP connection to the port number. 0 - cannot connect, 1 - can connect. IP address is optional. If ip is missing, 127.0.0.1 is used. Example: net.tcp.port[,80]');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','net.tcp.service.perf[service,&lt;ip&gt;,&lt;port&gt;]','Check performance of service &quot;service&quot;. 0 - service is down, sec - number of seconds spent on connection to the service. If ip is missing 127.0.0.1 is used.  If port number is missing, default service port is used.');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','net.tcp.service[service,&lt;ip&gt;,&lt;port&gt;]','Check if service is available. 0 - service is down, 1 - service is running. If ip is missing 127.0.0.1 is used. If port number is missing, default service port is used. Example: net.tcp.service[ftp,,45].');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','perf_counter[counter,&lt;interval&gt;]','Value of any performance counter, where "counter" parameter is the counter path and "interval" parameter is a number of last seconds, for which the agent returns an average value.');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','proc.mem[&lt;name&gt;,&lt;user&gt;,&lt;mode&gt;,&lt;cmdline&gt;]','Memory used by process with name name running under user user. Memory used by processes. Process name, user and mode is optional. If name or user is missing all processes will be calculated. If mode is missing sum is used. Example: proc.mem[,root]');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','proc.num[&lt;name&gt;,&lt;user&gt;,&lt;state&gt;,&lt;cmdline&gt;]','Number of processes with name name running under user user having state state. Process name, user and state are optional. Examples: proc.num[,mysql]; proc.num[apache2,www-data]; proc.num[,oracle,sleep,oracleZABBIX]');

UPDATE `help_items` SET `key_`='net.tcp.port[&lt;ip&gt;,port]'
  WHERE `itemtype`='7' AND `key_`='net.tcp.port[&lt;ip&gt;, port]';
UPDATE `help_items` SET `key_`='net.tcp.service.perf[service,&lt;ip&gt;,&lt;port&gt;]'
  WHERE `itemtype`='7' AND `key_`='net.tcp.service.perf[service &lt;,ip&gt; &lt;,port&gt;]';
UPDATE `help_items` SET `key_`='net.tcp.service[service,&lt;ip&gt;,&lt;port&gt;]'
  WHERE `itemtype`='7' AND `key_`='net.tcp.service[service &lt;,ip&gt; &lt;,port&gt;]';
UPDATE `help_items` SET `key_`='perf_counter[counter,&lt;interval&gt;]',
                      description='Value of any performance counter, where "counter" parameter is the counter path and "interval" parameter is a number of last seconds, for which the agent returns an average value.'
  WHERE `itemtype`='7' AND `key_`='perf_counter[counter]';
UPDATE `help_items` SET `key_`='proc.mem[&lt;name&gt;,&lt;user&gt;,&lt;mode&gt;,&lt;cmdline&gt;]'
  WHERE `itemtype`='7' AND `key_`='proc.mem[&lt;name&gt; &lt;,user&gt; &lt;,mode&gt; &lt;,cmdline&gt;]';
UPDATE `help_items` SET `key_`='proc.num[&lt;name&gt;,&lt;user&gt;,&lt;state&gt;,&lt;cmdline&gt;]'
  WHERE `itemtype`='7' AND `key_`='proc.num[&lt;name&gt; &lt;,user&gt; &lt;,state&gt; &lt;,cmdline&gt;]';

-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','system.cpu.load[&lt;cpu&gt; &lt;,mode&gt;]','CPU(s) load. Processor load. The cpu and mode are optional. If cpu is missing all is used. If mode is missing avg1 is used. Note that this is not percentage.');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','system.cpu.load[&lt;cpu&gt;,&lt;mode&gt;]','CPU(s) load. Processor load. The cpu and mode are optional. If cpu is missing all is used. If mode is missing avg1 is used. Note that this is not percentage.');

UPDATE `help_items` SET `key_`='system.cpu.load[&lt;cpu&gt;,&lt;mode&gt;]'
  WHERE `itemtype`='7' AND `key_`='system.cpu.load[&lt;cpu&gt; &lt;,mode&gt;]';

-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','system.cpu.util[&lt;cpu&gt; &lt;,type&gt; &lt;,mode&gt;]','CPU(s) utilisation. Processor load in percents. The cpu, type and mode are optional. If cpu is missing all is used.  If type is missing user is used. If mode is missing avg1 is used.');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','system.cpu.util[&lt;cpu&gt;,&lt;type&gt;,&lt;mode&gt;]','CPU(s) utilisation. Processor load in percents. The cpu, type and mode are optional. If cpu is missing all is used.  If type is missing user is used. If mode is missing avg1 is used.');

UPDATE `help_items` SET `key_`='system.cpu.util[&lt;cpu&gt;,&lt;type&gt;,&lt;mode&gt;]'
  WHERE `itemtype`='7' AND `key_`='system.cpu.util[&lt;cpu&gt; &lt;,type&gt; &lt;,mode&gt;]';

-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','system.run[command,&lt;mode&gt]','Run specified command on the host.');
-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','system.stat[resource &lt;,type&gt;]','Virtual memory statistics.');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','system.run[command,&lt;mode&gt;]','Run specified command on the host.');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','system.stat[resource,&lt;type&gt;]','Virtual memory statistics.');

UPDATE `help_items` SET `key_`='system.run[command,&lt;mode&gt;]'
  WHERE `itemtype`='7' AND `key_`='system.run[command,&lt;mode&gt]';
UPDATE `help_items` SET `key_`='system.stat[resource,&lt;type&gt;]'
  WHERE `itemtype`='7' AND `key_`='system.stat[resource &lt;,type&gt;]';

-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','system.swap.in[&lt;swap&gt; &lt;,type&gt;]','Swap in. If type is count - swapins is returned. If type is pages - pages swapped in is returned. If swap is missing all is used.');
-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','system.swap.out[&lt;swap&gt; &lt;,type&gt;]','Swap out. If type is count - swapouts is returned. If type is pages - pages swapped in is returned. If swap is missing all is used.');
-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','system.swap.size[&lt;swap&gt; &lt;,mode&gt;]','Swap space. Number of bytes. If swap is missing all is used. If mode is missing free is used.');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','system.swap.in[&lt;swap&gt;,&lt;type&gt;]','Swap in. If type is count - swapins is returned. If type is pages - pages swapped in is returned. If swap is missing all is used.');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','system.swap.out[&lt;swap&gt;,&lt;type&gt;]','Swap out. If type is count - swapouts is returned. If type is pages - pages swapped in is returned. If swap is missing all is used.');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','system.swap.size[&lt;swap&gt;,&lt;mode&gt;]','Swap space. Number of bytes. If swap is missing all is used. If mode is missing free is used.');

UPDATE `help_items` SET `key_`='system.swap.in[&lt;swap&gt;,&lt;type&gt;]'
  WHERE `itemtype`='7' AND `key_`='system.swap.in[&lt;swap&gt; &lt;,type&gt;]';
UPDATE `help_items` SET `key_`='system.swap.out[&lt;swap&gt;,&lt;type&gt;]'
  WHERE `itemtype`='7' AND `key_`='system.swap.out[&lt;swap&gt; &lt;,type&gt;]';
UPDATE `help_items` SET `key_`='system.swap.size[&lt;swap&gt;,&lt;mode&gt;]'
  WHERE `itemtype`='7' AND `key_`='system.swap.size[&lt;swap&gt; &lt;,mode&gt;]';

-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','vfs.dev.read[device &lt;,type&gt; &lt;,mode&gt;]','Device read statistics.');
-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','vfs.dev.write[device &lt;,type&gt; &lt;,mode&gt;]','Device write statistics.');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','vfs.dev.read[device,&lt;type&gt;,&lt;mode&gt;]','Device read statistics.');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','vfs.dev.write[device,&lt;type&gt;,&lt;mode&gt;]','Device write statistics.');

UPDATE `help_items` SET `key_`='vfs.dev.read[device,&lt;type&gt;,&lt;mode&gt;]'
  WHERE `itemtype`='7' AND `key_`='vfs.dev.read[device &lt;,type&gt; &lt;,mode&gt;]';
UPDATE `help_items` SET `key_`='vfs.dev.write[device,&lt;type&gt;,&lt;mode&gt;]'
  WHERE `itemtype`='7' AND `key_`='vfs.dev.write[device &lt;,type&gt; &lt;,mode&gt;]';

INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','vfs.file.contents[file,&lt;encoding&gt;]','Get contents of a given file.');

-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','vfs.file.md5sum[file]','Calculate MD5 check sum of a given file. String MD5 hash of the file. Can be used for files less than 64MB, unsupported otherwise. Example: vfs.file.md5sum[/etc/zabbix/zabbix_agentd.conf]');
-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','vfs.file.regexp[file,regexp]','Find string in a file. Matched string');
-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','vfs.file.regmatch[file,regexp]','Find string in a file. 0 - expression not found, 1 - found');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','vfs.file.md5sum[file]','Calculate MD5 check sum of a given file. String MD5 hash of the file. Can be used for files less than 64MB, unsupported otherwise. Example: vfs.file.md5sum[/usr/local/etc/zabbix_agentd.conf]');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','vfs.file.regexp[file,regexp,&lt;encoding&gt;]','Find string in a file. Matched string');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','vfs.file.regmatch[file,regexp,&lt;encoding&gt;]','Find string in a file. 0 - expression not found, 1 - found');

UPDATE `help_items` SET description='Calculate MD5 check sum of a given file. String MD5 hash of the file. Can be used for files less than 64MB, unsupported otherwise. Example: vfs.file.md5sum[/usr/local/etc/zabbix_agentd.conf]'
  WHERE `itemtype`='7' AND description='Calculate MD5 check sum of a given file. String MD5 hash of the file. Can be used for files less than 64MB, unsupported otherwise. Example: vfs.file.md5sum[/etc/zabbix/zabbix_agentd.conf]';
UPDATE `help_items` SET `key_`='vfs.file.regexp[file,regexp,&lt;encoding&gt;]'
  WHERE `itemtype`='7' AND `key_`='vfs.file.regexp[file,regexp]';
UPDATE `help_items` SET `key_`='vfs.file.regmatch[file,regexp,&lt;encoding&gt;]'
  WHERE `itemtype`='7' AND `key_`='vfs.file.regmatch[file,regexp]';

-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','vfs.file.time[file&lt;, mode&gt;]','File time information. Number of seconds.The mode is optional. If mode is missing modify is used.');
-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','vfs.fs.inode[fs &lt;,mode&gt;]','Number of inodes for a given volume. If mode is missing total is used.');
-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','vfs.fs.size[fs &lt;,mode&gt;]','Calculate disk space for a given volume. Disk space in KB. If mode is missing total is used.  In case of mounted volume, unused disk space for local file system is returned. Example: vfs.fs.size[/tmp,free].');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','vfs.file.time[file,&lt;mode&gt;]','File time information. Number of seconds.The mode is optional. If mode is missing modify is used.');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','vfs.fs.inode[fs,&lt;mode&gt;]','Number of inodes for a given volume. If mode is missing total is used.');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('7','vfs.fs.size[fs,&lt;mode&gt;]','Calculate disk space for a given volume. Disk space in KB. If mode is missing total is used.  In case of mounted volume, unused disk space for local file system is returned. Example: vfs.fs.size[/tmp,free].');

UPDATE `help_items` SET `key_`='vfs.file.time[file,&lt;mode&gt;]'
  WHERE `itemtype`='7' AND `key_`='vfs.file.time[file&lt;, mode&gt;]';
UPDATE `help_items` SET `key_`='vfs.fs.inode[fs,&lt;mode&gt;]'
  WHERE `itemtype`='7' AND `key_`='vfs.fs.inode[fs &lt;,mode&gt;]';
UPDATE `help_items` SET `key_`='vfs.fs.size[fs,&lt;mode&gt;]'
  WHERE `itemtype`='7' AND `key_`='vfs.fs.size[fs &lt;,mode&gt;]';

-- -INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('8','grpfunc[&lt;Group&gt;,&lt;Key&gt;,&lt;func&gt;,&lt;param&gt;]','Aggregate checks do not require any agent running on a host being monitored. Zabbix server collects aggregate information by doing direct database queries. See Zabbix Manual.');
-- +INSERT INTO `help_items` (`itemtype`,`key_`,`description`) values ('8','grpfunc[&lt;group&gt;,&lt;key&gt;,&lt;func&gt;,&lt;param&gt;]','Aggregate checks do not require any agent running on a host being monitored. Zabbix server collects aggregate information by doing direct database queries. See Zabbix Manual.');

UPDATE `help_items` SET `key_`='grpfunc[&lt;group&gt;,&lt;key&gt;,&lt;func&gt;,&lt;param&gt;]'
  WHERE `itemtype`='8' AND `key_`='grpfunc[&lt;Group&gt;,&lt;Key&gt;,&lt;func&gt;,&lt;param&gt;]';

COMMIT;

