# Template for setting up Hatohol server and ZBX server on CentOS6.
#
# Note that this ks setup static ip configuration and asssumes
# the IP address of OpenStack's controller node is 10.0.0.10 and lives in the
# same network segment.
# Use openstack_public.xml in the same directory as the network configuration
# if you're planning to apply this to KVM.
#
install

url --url http://mirror.centos.org/centos/6/os/x86_64

# Keyboard layouts
keyboard jp106
# System language
lang ja_JP.UTF-8
# Network information
network --onboot yes --device eth0 --bootproto static --ip=10.0.0.40 --netmask=255.255.255.0 --gateway=10.0.0.1 --nameserver=10.0.0.1 --noipv6 --hostname=hatohol
# Root password
rootpw --plaintext centos
firewall --service=ssh
authconfig --enableshadow --passalgo=sha512
selinux --disabled
# System timezone
timezone Asia/Tokyo --isUtc
# System bootloader configuration
bootloader --location=mbr
reboot

zerombr
clearpart --all --initlabel
part /boot --fstype=ext4 --size=128
part swap --recommended
part / --fstype=ext4 --size=1 --grow

repo --name="Epel" --baseurl=http://dl.fedoraproject.org/pub/epel/6/x86_64 --cost=1000
repo --name="Hatohol" --baseurl=http://project-hatohol.github.io/repo/x86_64 --cost=1000

%packages --nobase
@core
epel-release
wget
mysql-server
qpid-cpp-server
hatohol-server
hatohol-server
hatohol-web
hatohol-arm-ceilometer
%end

%post --log=/root/ks-post-anaconda.log
#
# Hatohol setup
#
wget -P /etc/yum.repos.d/ http://project-hatohol.github.io/repo/hatohol.repo

chkconfig mysqld on
service mysqld start
hatohol-db-initiator hatohol root ""

mysql -uroot <<EOF
create database hatohol_client;
grant all privileges on hatohol_client.* to hatohol@localhost identified by 'hatohol';
EOF

/usr/libexec/hatohol/client/manage.py syncdb

sed -i 's/^#\(auth\)=.*/\1=no/' /etc/qpidd.conf
echo "acl allow all all" > /etc/qpid/qpidd.acl
chkconfig qpidd on

echo "10.0.0.10 controller" >> /etc/hosts

sed -i 's/^\(SELINUX\)=.*/\1=permissive/' /etc/selinux/config

chkconfig httpd on


#
# ZBX setup
#
DB_PASSWD=password

rpm --import http://ftp.miraclelinux.com/zbx/RPM-GPG-KEY-MIRACLE
yum -y install http://ftp.miraclelinux.com/zbx/2.2/miracle-zbx-release-2.2-1.noarch.rpm
yum -y install zabbix zabbix-server zabbix-server-mysql zabbix-web zabbix-web-mysql zabbix-web-japanese zabbix-agent zabbix-java-gateway

cat <<EOF >>/etc/my.cnf
[mysqld]
character-set-server=utf8
skip-character-set-client-handshake
innodb_file_per_table
innodb_log_buffer_size=16M
innodb_buffer_pool_size=512M
innodb_log_file_size=128M
innodb_log_files_in_group=2
key_buffer_size=100M
max_allowed_packet=16MB
EOF

service mysqld restart

cat <<EOF | mysql -uroot
create database zabbix;
grant all privileges on zabbix.* to zabbix@localhost identified by "$DB_PASSWD";
flush privileges;
exit
EOF

SCHEMA_SQL=`rpm -ql zabbix-server-mysql | grep schema.sql`
IMAGES_SQL=`rpm -ql zabbix-server-mysql | grep images.sql`
DATA_SQL=`rpm -ql zabbix-server-mysql | grep data.sql`
echo "mysql zabbix -uzabbix -p\"$DB_PASSWD\" < $SCHEMA_SQL"
mysql zabbix -uzabbix -p"$DB_PASSWD" < $SCHEMA_SQL
echo "mysql zabbix -uzabbix -p\"$DB_PASSWD\" < $IMAGES_SQL"
mysql zabbix -uzabbix -p"$DB_PASSWD" < $IMAGES_SQL
echo "mysql zabbix -uzabbix -p\"$DB_PASSWD\" < $DATA_SQL"
mysql zabbix -uzabbix -p"$DB_PASSWD" < $DATA_SQL

sed -i -e 's/^\(DBName\)=.*/\1=zabbix/' -e 's/^\(DBUser\)=.*/\1=zabbix/' /etc/zabbix/zabbix_server.conf
sed -i -e '/^# DBPassword=.*/a DBPassword=password' /etc/zabbix/zabbix_server.conf
sed -i -e '/^# StartJavaPollers=.*/a StartJavaPollers=1' /etc/zabbix/zabbix_server.conf
sed -i -e '/^# JavaGateway=.*/a JavaGateway=127.0.0.1' /etc/zabbix/zabbix_server.conf

chkconfig zabbix-server on

sed -i -e 's/^#//' /etc/httpd/conf.d/zabbix.conf

sed -i -e 's/^\(Server\)=.*/\1=127.0.0.1/' \
       -e 's/^\(ServerActive\)=.*/\1=127.0.0.1/' \
       -e 's/^\(Hostname\)=.*/\1=Zabbix server/' /etc/zabbix/zabbix_agentd.conf

chkconfig zabbix-agent on

%end

