# Template for bare CentOS6.
#
# This is the most simple and compact installation of CentOS6.
#
install

url --url http://mirror.centos.org/centos/6/os/x86_64

# Keyboard layouts
keyboard jp106
# System language
lang ja_JP.UTF-8
# Network information
network --onboot yes --device eth0 --bootproto dhcp --noipv6 --hostname=centos6
# Root password
rootpw --plaintext centos
firewall --service=ssh
authconfig --enableshadow --passalgo=sha512
selinux --disabled
# System timezone
timezone Asia/Tokyo --isUtc
# System bootloader configuration
bootloader --location=mbr
reboot

zerombr
clearpart --all --initlabel
part /boot --fstype=ext4 --size=128
part swap --recommended
part / --fstype=ext4 --size=1 --grow

%packages --nobase
@core
%end
