# Template for setting up Hatohol server on CentOS6.
#
# Note that this ks setup static ip configuration and asssumes
# the IP address of OpenStack's controller node is 10.0.0.10 and lives in the
# same network segment.
# Use openstack_public.xml in the same directory as the network configuration
# if you're planning to apply this to KVM.
#
install

url --url http://mirror.centos.org/centos/6/os/x86_64

# Keyboard layouts
keyboard jp106
# System language
lang ja_JP.UTF-8
# Network information
network --onboot yes --device eth0 --bootproto static --ip=10.0.0.40 --netmask=255.255.255.0 --gateway=10.0.0.1 --nameserver=10.0.0.1 --noipv6 --hostname=hatohol
# Root password
rootpw --plaintext centos
firewall --service=ssh
authconfig --enableshadow --passalgo=sha512
selinux --disabled
# System timezone
timezone Asia/Tokyo --isUtc
# System bootloader configuration
bootloader --location=mbr
reboot

zerombr
clearpart --all --initlabel
part /boot --fstype=ext4 --size=128
part swap --recommended
part / --fstype=ext4 --size=1 --grow

repo --name="Epel" --baseurl=http://dl.fedoraproject.org/pub/epel/6/x86_64 --cost=1000
repo --name="Hatohol" --baseurl=http://project-hatohol.github.io/repo/x86_64 --cost=1000

%packages --nobase
@core
epel-release
wget
mysql-server
qpid-cpp-server
hatohol-server
hatohol-server
hatohol-web
hatohol-arm-ceilometer
%end

%post --log=/root/ks-post-anaconda.log
wget -P /etc/yum.repos.d/ http://project-hatohol.github.io/repo/hatohol.repo

chkconfig mysqld on
service mysqld start
hatohol-db-initiator hatohol root ""

mysql -uroot <<EOF
create database hatohol_client;
grant all privileges on hatohol_client.* to hatohol@localhost identified by 'hatohol';
EOF

/usr/libexec/hatohol/client/manage.py syncdb

sed -i 's/^#\(auth\)=.*/\1=no/' /etc/qpidd.conf
echo "acl allow all all" > /etc/qpid/qpidd.acl
chkconfig qpidd on

echo "10.0.0.10 controller" >> /etc/hosts

sed -i 's/^\(SELINUX\)=.*/\1=permissive/' /etc/selinux/config

chkconfig httpd on
%end
